const { DataTypes, sequelize } = require("sequelize");



module.exports = (sequelize) => {
  const Salespersons = sequelize.define('Salespersons', {
    RepID: {
      type: DataTypes.STRING(10),
      allowNull: false,
      primaryKey: true,
    },
    LocationCode: {
      type: DataTypes.SMALLINT,
      allowNull: false,
    },
    EmpNo: {
      type: DataTypes.STRING(10),
      allowNull: false,
      defaultValue: '',
    },
    RepType: {
      type: DataTypes.TINYINT,
      allowNull: true,
    },
    RepName: {
      type: DataTypes.STRING(60),
      allowNull: false,
    },
    ContactNo: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    Email: {
      type: DataTypes.STRING(100),
      allowNull: false,
    },
    Remark: {
      type: DataTypes.STRING(150),
      allowNull: false,
    },
    RepImage: {
      type: DataTypes.BLOB('long'),
      allowNull: true,
    },
    IsSalesPerson: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
    },
    IsTec: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    Skill: {
      type: DataTypes.TINYINT,
      allowNull: true,
    },
    IsAccount: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    IsActive: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
    },
  }, {
    tableName: 'salespersons', // Explicitly set the table name
    timestamps: false, // No createdAt or updatedAt
    charset: 'latin1', // Match character set
    collate: 'latin1_swedish_ci', // Optional, use if needed
  });

  return Salespersons;
};


