const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const Rental_Payment_Dtl = sequelize.define('rental_payment_dtl',{

        AccNo: {
            type: DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            autoIncrement: false,
        },
        InvNo: {
            type: DataTypes.STRING,
            allowNull: true,
            default:''
        
        },
        Month: {
            type: DataTypes.INTEGER,
            allowNull: false,
            default:'0'
        },
        MonPayment: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        PaymentDate: {
            type: DataTypes.DATEONLY,
            allowNull: true
        },
        DueAmountWExtra: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        RentalDefault: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        WRentalDefault: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        TotalDue: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        RentalBalance: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        RentalRate: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        RentalExcuseDays: {
            type: DataTypes.INTEGER,
            allowNull: true
        },
        Principal: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        Interest: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        ExtraAmount: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        Balance: {
            type: DataTypes.DECIMAL,
            allowNull: true
        },
        IsPaid: {
            type: DataTypes.DECIMAL,
            allowNull: true,
            default:'0'
        },
        SettleAmount: {
            type: DataTypes.DECIMAL,
            allowNull: true,
            default:'0.00'
        },
        IsCancel: {
            type: DataTypes.TINYINT,
            allowNull: true,
            default:'0'
        }
    },{
        tableName: 'rental_payment_dtl', 
        freezeTableName: true,
        timestamps: false,      
    }
   );
    return Rental_Payment_Dtl;
    
};





