const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
const RentalPaidCollector = sequelize.define('RentalPaidCollector', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
      },
      ref_id: {
        type: DataTypes.STRING,
        allowNull: false,
        defaultValue: 0,
        field: 'ref_id', // Explicitly map to database column
      },
      payment_Id: {
        type: DataTypes.STRING,
        allowNull: false,
        field: 'payment_Id', // Explicitly map to database column
      },
      date: {
        type: DataTypes.DATEONLY,
        allowNull: false,
        field: 'date', // Explicitly map to database column
      },
      route_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: 0,
        field: 'route_id', // Explicitly map to database column
      },
}, {
  tableName: 'rental_paid_collector',
  timestamps: false, 
  underscored: true, 
});
return RentalPaidCollector;
}
