const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const Invoicehed = sequelize.define('invoicehed',{

        AppNo: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        InvType: {
            type: DataTypes.TINYINT,
            defaultValue: 1,
            allowNull: false,
        },  InvNo: {
            type: DataTypes.STRING,
            allowNull: false,
            primaryKey:true,

        },
        InvLocation: {
            type: DataTypes.SMALLINT,
            allowNull: false,
            primaryKey: true,
        },
        Inv_PO_No: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        InvJobCardNo: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        InvDate: {
            type: DataTypes.DATE,
            allowNull: false,
        },
        InvCounterNo: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        InvRootNo: {
            type: DataTypes.SMALLINT,
            allowNull: false,
        },
        InvCustomer: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        InvDisAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvDisPercentage: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvCashAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvCCardAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvCreditAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvReturnPayment: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvGiftVAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvLoyaltyAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvStarPoints: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvChequeAmount: {
            type: DataTypes.DECIMAL,
            allowNull: true,
        },
        InvAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvIsVat: {
            type: DataTypes.TINYINT,
            allowNull: false,
        },
        InvVatAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvIsNbt: {
            type: DataTypes.TINYINT,
            allowNull: false,
        },
        InvNbtRatioTotal: {
            type: DataTypes.DECIMAL,
            allowNull: true,
        },
        InvNbtAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvNetAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvCustomerPayment: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvCostAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvRefundAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvUser: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        InvHold: {
            type: DataTypes.TINYINT,
            allowNull: false,
        },
        InvIsCancel: {
            type: DataTypes.TINYINT,
            allowNull: false,
        },
        IsComplete: {
            type: DataTypes.TINYINT,
            allowNull: false,
        },
        Flag: {
            type: DataTypes.TINYINT,
            allowNull: false,
        }
    },{
        tableName: 'invoicehed', 
        timestamps: false,      
    }
   );
    return Invoicehed;
    
};




