const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const Invoice_hed= sequelize.define('invoice_hed',{

        InvNo: {
            type: DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            autoIncrement: false,
        },
        AccNo: {
            type: DataTypes.STRING,
            defaultValue: 1,
            allowNull: true,
        },  Location: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        InvDate: {
            type: DataTypes.DATE,
            allowNull: true, 
        },
        InvType: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        ItemType: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        TotalAmount: {
            type: DataTypes.DECIMAL,
            allowNull: true,
        },
        DisPercentage: {
            type: DataTypes.DECIMAL,
            allowNull: true,
        },
        DisAmount: {
            type: DataTypes.DECIMAL,
            allowNull: true,
        },
        CashPayment: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        DownPayment: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        TotalExCharges: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        RefundAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        TotalExAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        TotalDwPayment: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        QuarterPayment: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        FinalAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InterestTerm: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        InterestRate: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        Interest: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        GrossAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        Installments: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        TotalPaid: {
            type: DataTypes.DECIMAL,
            allowNull: true,
            default:'0.00'
        },
        TotalDue: {
            type: DataTypes.DECIMAL,
            allowNull: false,
            default:'0.00'
        },
        InstallAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        InvUser: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        IsCancel: {
            type: DataTypes.TINYINT,
            allowNull: false,
            default:'0'
        },
        IsComplete: {
            type: DataTypes.TINYINT,
            allowNull: false,
            default:'0'
        },
        IsReturn: {
            type: DataTypes.TINYINT,
            allowNull: false,
            default:'0'
        },
        payt_type: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        pay_date: {
            type: DataTypes.DATE,
            allowNull: false,
        },
        chequeAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        },
        DueAmount: {
            type: DataTypes.DOUBLE,
            allowNull: true,
        },
        SeettuNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        OverPayment: {
            type: DataTypes.DECIMAL,
            allowNull: true,
        },
        CusCode: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        firstPayment: {
            type: DataTypes.DECIMAL,
            allowNull: true,
            default:'0.00'
        },
        lastDate: {
            type: DataTypes.DATE,
            allowNull: true,
        },
        penalty: {
            type: DataTypes.DECIMAL,
            allowNull: true,
            default:'0.00'
        },
        penaltyStatus: {
            type: DataTypes.INTEGER,
            allowNull: true,
        }
    },{
        tableName: 'invoice_hed', 
        timestamps: false,      
    }
   );
    return Invoice_hed;
    
};




