const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const DailyEmployeeRoutes = sequelize.define('DailyEmployeeRoutes', {
        id: {
          type: DataTypes.INTEGER.UNSIGNED,
          allowNull: false,
          autoIncrement: true,
          primaryKey: true,
        },
        salesperson: {
          type: DataTypes.STRING(20),
          allowNull: false,
        },
        inv_date: {
          type: DataTypes.DATEONLY,
          allowNull: false,
        },
        routes: {
          type: DataTypes.TEXT,
          allowNull: false,
          // Add getter and setter to handle JSON parsing
          get() {
            const rawValue = this.getDataValue('routes');
            return rawValue ? JSON.parse(rawValue) : null;
          },
          set(value) {
            this.setDataValue('routes', JSON.stringify(value));
          },
        },
        code: {
          type: DataTypes.INTEGER,
          allowNull: false,
        },
      }, {
        tableName: 'daily_employee_routes', // Match the table name exactly
        timestamps: false, // No createdAt or updatedAt fields
        charset: 'latin1', // Match the charset
        collate: 'latin1_swedish_ci', // Optional, depending on DB configuration
      });
    
      return DailyEmployeeRoutes;
};





