const { DataTypes } = require('sequelize');

module.exports = (sequelize) => {
  const CustomerOutstanding = sequelize.define('CustomerOutstanding', {
    CusCode: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      validate: {
        isInt: true,
      },
    },
    CusTotalInvAmount: {
      type: DataTypes.DECIMAL(18, 2),
      allowNull: false,
      validate: {
        isDecimal: true,
      },
    },
    CusOustandingAmount: {
      type: DataTypes.DECIMAL(18, 2),
      allowNull: false,
      validate: {
        isDecimal: true,
      },
    },
    CusSettlementAmount: {
      type: DataTypes.DECIMAL(18, 2),
      allowNull: false,
      validate: {
        isDecimal: true,
      },
    },
    OpenOustanding: {
      type: DataTypes.DECIMAL(18, 2),
      allowNull: false,
      validate: {
        isDecimal: true,
      },
    },
    OustandingDueAmount: {
      type: DataTypes.DECIMAL(18, 2),
      allowNull: false,
      validate: {
        isDecimal: true,
      },
    },
    old_cus: {
      type: DataTypes.BIGINT,
      allowNull: true,
    },
  }, {
    tableName: 'customeroutstanding',
    timestamps: false, // No createdAt/updatedAt fields

  });

  return CustomerOutstanding;
};
