const { DataTypes } = require('sequelize');

module.exports = (sequelize) => {
  const CodeGenerate = sequelize.define('CodeGenerate', {
    FormName: {
      type: DataTypes.STRING(30),
      allowNull: false,
      primaryKey: true,
    },
    FormCode: {
      type: DataTypes.STRING(4),
      allowNull: false,
      primaryKey: true,
    },
    AutoNumber: {
      type: DataTypes.DECIMAL(8, 0),
      allowNull: false,
      primaryKey: true,
    },
    CodeLimit: {
      type: DataTypes.STRING(8),
      allowNull: false,
    },
    FCLength: {
      type: DataTypes.SMALLINT,
      allowNull: false,
    },
  }, {
    tableName: 'codegenerate',
    timestamps: false,
    indexes: [
      {
        unique: true,
        fields: ['FormName', 'FormCode', 'AutoNumber'],
      },
    ],
  });

  return CodeGenerate;
};
