const { Model, where, Sequelize, Op } = require('sequelize');
const { models: { Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails, RentalPaid, RentalPaidCollector,CodeGenerate}, sequelize } = require('../config/DB_config');



const getLastPaymentID = async (req, res, next) => {

    try {
        const lastRecord = await CodeGenerate.findOne({
            attributes: ['FormName', 'AutoNumber', 'FormCode', 'FCLength'],
            where: { FormName: 'LoanPaymentNo' }
        });
        const formLenth = Number(lastRecord.FCLength);
        let nextNum = Number(lastRecord.AutoNumber) + 1;
        const nextId = nextNum.toString().padStart(formLenth, '0');
        const nextPayId = lastRecord.FormCode + nextId
        console.log('nextPayId', nextPayId)
        req.paymentId = nextPayId;
        req.rowPayId = nextNum;
        next();
    } catch (error) {
        console.error("Error fetching the last record:", error);
        res.status(500).send("An error occurred while saving data.");
    }
};


const getLastRecord = async () => {

    try {
        const lastRecord = await RentalPaid.findOne({
            attributes: ['PaymentId'],
            order: [
                [sequelize.literal("CAST(REPLACE(PaymentId, 'LP', '') AS SIGNED)"), 'DESC']
            ]
        });
        // console.log('lastRecord', lastRecord)
        return lastRecord;
    } catch (error) {
        console.error("Error fetching the last record:", error);
        res.status(500).send("An error occurred while saving data.");
    }
};




const saveRentalPaid = async (req, res, next) => {
    // console.log('saveRentalPaid');

    if (req.paymentId) {
        const paymentId = req.paymentId;
        console.log('paymentId', paymentId);
        try {
            const { paymentType, payDate, invNo, cusCode, checkRecDate, checkDate, CheckRef, payAmount, settleAmount, invoiceClose, checkNo, cashAmount, checkAmount, insAmount, invDate, accNo, saleParsan, rootId } = req.body;
            const OverPayAmount = 0;
            const overPayInv = 0;
            const exAmount = 0.0;
            if (paymentId, paymentType, payDate, invNo, cusCode, payAmount, settleAmount, invoiceClose, cashAmount, OverPayAmount, overPayInv, exAmount, insAmount, invDate, accNo, saleParsan, rootId) {


                try {
                    const parameters = {
                        P_PaymentId: req.paymentId,
                        P_PaymentType: req.body.paymentType,
                        P_PayDate: req.body.payDate,
                        P_InvNo: req.body.invNo,
                        P_CusCode: req.body.cusCode,
                        P_ChequeRecDate: null, // Use `null` if not provided
                        P_ChequeDate: null,       // Use `null` instead of an empty string
                        P_ChequeReference: req.body.chequeReference || '',
                        P_PayAmount: req.body.payAmount,
                        P_SettleAmount: req.body.settleAmount,
                        P_InvoiceColse: 0,
                        P_ChequeNo: req.body.chequeNo || '',
                        P_CashAmount: req.body.cashAmount,
                        P_ChequeAmount: 0,
                        P_Over_PayAmount: 0.00,
                        P_Over_PayInv: '',
                        P_ExAmount: req.body.exAmount,
                        P_InsAmount: req.body.insAmount,
                        P_InvDate: req.body.invDate,
                        P_AccNo: req.body.accNo,
                        P_penalty: 0.00,
                        P_remark: 'No Remark'
                    };

                    console.log(parameters);


                    const result = await sequelize.query(
                        `CALL SPT_SAVE_RENTAL_PAID(
            :P_PaymentId, :P_PaymentType, :P_PayDate, :P_InvNo, :P_CusCode, :P_ChequeRecDate,
            :P_ChequeDate, :P_ChequeReference, :P_PayAmount, :P_SettleAmount, :P_InvoiceColse,
            :P_ChequeNo, :P_CashAmount, :P_ChequeAmount, :P_Over_PayAmount, :P_Over_PayInv,
            :P_ExAmount, :P_InsAmount, :P_InvDate, :P_AccNo, :P_penalty, :P_remark
        )`,
                        {
                            replacements: parameters,
                            type: sequelize.QueryTypes.RAW
                        }
                    );

                    next();
                } catch (error) {
                    console.error(error);
                    res.status(500).send("An error occurred while saving data.");
                }


            } else {
                console.log(error);
                res.status(500).send("An error occurred while saving data.");
            }


        } catch (error) {
            console.log(error);
            res.status(500).send("An error occurred while saving data.");
        }
    } else {
        res.send('payment id not found')
    }
}
function incrementPaymentId(paymentId) {
    // console.log('incrementPaymentId');
    const prefix = paymentId.slice(0, 2);
    const numberPart = parseInt(paymentId.slice(2));

    const incrementedNumber = numberPart + 1;


    const newNumberPart = incrementedNumber.toString().padStart(paymentId.length - 2, '0');

    return prefix + newNumberPart;
}



async function calsalRentalPaid(pId, payAmo, cus) {

    try {
        if (balance = payAmo) {




            const cusOutOld = await CustomerOutstanding.findOne({
                attributes: [
                    'CusOustandingAmount',
                ],
                where: {
                    CusCode: cus
                }
            }).then(async (data) => {
                console.log(data.CusOustandingAmount);

                const cusOutstadingAmount = Number(data.CusOustandingAmount) - Number(payAmo);

                await CustomerOutstanding.update(
                    { CusOustandingAmount: cusOutstadingAmount },
                    {
                        where: {
                            CusCode: cus
                        }
                    }
                );

            })

            const isdelete = await RentalPaid.destroy({
                where: {
                    PaymentId: pId
                },
            }).then((data) => {
                console.log('isdelete', data)
            })





            return 201;

            //res.status(201).send({msg:'payment not saved'});
        } else {
            return 202;
            // res.status(202).send({msg:balance});
        }
    } catch (error) {
        console.log(error);

    }


}





async function updateInvoiceHed(req, res, next) {
    const { invNo, payAmount } = req.body;
    const payment = Number(payAmount);
    try {

        const invHed = await Invoice_hed.findOne({

            where: { InvNo: invNo }
        });



        const firstPayment = Number(invHed.firstPayment);
        const totalPaid = Number(invHed.TotalPaid);
        const totalDue = Number(invHed.TotalDue);
        const finalAmount = Number(invHed.FinalAmount);

        if (totalDue === 0.0 && firstPayment === 0.0 && totalPaid === 0.0) {

            const ttldue = finalAmount - payment;
            console.log("ttldue", ttldue);
            const isComplete = 0;
            if (ttldue < 0) {
                ttldue = 0.0;
                isComplete = 0;
            }



            await Invoice_hed.update(
                { TotalPaid: payment, TotalDue: ttldue, firstPayment: payment, IsComplete: isComplete },
                {
                    where: {

                        InvNo: invNo,

                    }
                },
            )
        } else {

            if (finalAmount > (payAmount + totalPaid)) {

                const totalPayment = payAmount + totalPaid;
                const newTotalDue = totalDue - payAmount;
                const isComplete = 0;
                if (newTotalDue < 0) {
                    newTotalDue = 0.0;
                    isComplete = 0;


                }

                await Invoice_hed.update(
                    { TotalPaid: totalPayment, TotalDue: newTotalDue, IsComplete: isComplete },
                    {
                        where: {

                            InvNo: invNo,

                        }
                    },
                )
            } else {

                await Invoice_hed.update(
                    { TotalPaid: finalAmount, TotalDue: 0.0, IsComplete: 1 },
                    {
                        where: {

                            InvNo: invNo,

                        }
                    },
                )
            }


        }
        next();
    } catch (error) {
        console.log(error);
        res.send(error)
    }
}


async function saveCollecting(req, res, next) {
    console.log('save collect');
    try {
        const paymentId = req.paymentId;
        const { payDate, rootId, saleParsan } = req.body;
        // Create a new user


        await RentalPaidCollector.create({
            payment_Id: paymentId,
            date: payDate,
            route_id: rootId,
            ref_id: saleParsan
        }).then((data) => {

            console.log('save collect then', data.id);
            next();
        }
        );


    } catch (error) {
        console.log(error);
        res.send(error)

    }
}
module.exports = { getLastPaymentID, saveRentalPaid, updateInvoiceHed, saveCollecting };