const { Model, where, Sequelize, Op } = require('sequelize');
const { models: { Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails, Item_interest, Salespersons, DailyEmployeeRoutes }, sequelize } = require('../config/DB_config');
const dayEmployeeRoutes = require('../modules/dayEmployeeRoutes');
const { Where } = require('sequelize/lib/utils');
const salesPerson = require('../modules/salesPerson');



module.exports = {

  GetAllOfficers: async (req, res) => {

    if (req.query.type) {
      let mySearchObj = Users;
      att = {
        attributes: ['username', 'id'],
      }
      if (req.query.type === 'officers') {
        att = {
          attributes: ['username', 'id'],
        }
        mySearchObj = Users;

      } else if (req.query.type === 'turms') {
        att = {
          attributes: ['IntId', 'IntTerm'],
        }
        mySearchObj = Item_interest;
      } else if (req.query.type === 'root') {
        att = {
          attributes: ['id', 'code', 'name'],
        }
        mySearchObj = RootList;
      }

      try {
        const data = await mySearchObj.findAll(att);

        res.json(data)
      } catch (error) {
        console.log(error);
        res.send(error)
      }
    } else {
      console.log('no data input')
    }
  },

  LOGIN: async (req, res) => {
    if (req.query.userName && req.query.code) {
      const { userName, code } = req.query;
      const today = getToday();
      console.log(today);
      try {




        const dayEmp = await DailyEmployeeRoutes.findOne({

          where: {
            inv_date: today,
            code: code
          },
          include: [{
            model: Salespersons,
            required: true,
            where: {
              RepName: userName
            }

          }]

        }).then(data => {
          res.send(data);
        })





      } catch (error) {
        console.log(error);
        res.send({ msg: error });
      }



    }
  },

  GET_EMPLOYEE_ROO: async (req, res) => {
    const today = getToday();

    if (req.query.userID) {
      const userID=req.query.userID;
      attributes:['routes']
      const dayEmp = await DailyEmployeeRoutes.findOne({
        where:{
          salesPerson:userID,
          inv_date:today
        }
      }).then(async(responce)=>{
        console.log("root list is",responce.dataValues.routes);
   
        const rootArray=responce.dataValues.routes;
        console.log(rootArray.length);
        const rootData=[{}];
/*
        for(let i=0;i<rootArray.length;i++){
          console.log(rootArray[i]);
        }
*/

      
rootArray.forEach(async (element) => {
  console.log('Element:', element);

  try {
    const data = await RootList.findAll({
      attributes: ['id', 'name'], // Correct attribute property
      where: {
        id: element, // Assuming 'key' is 'element' directly
      },
    });
    console.log('Data:', data);
  } catch (err) {
    console.error('Error fetching data:', err);
  }
});


      })
    }



    },
    GET_EMPLOYEE_ROOT: async (req, res) => {
      const today = getToday();
    
      if (req.query.userID) {
        const userID = req.query.userID;
    
        try {
          const dayEmp = await DailyEmployeeRoutes.findOne({
            where: {
              salesPerson: userID,
              inv_date: today,
            },
          });
    
          if (dayEmp && dayEmp.dataValues.routes) {
     
            let rootArray = dayEmp.dataValues.routes;
    
        
            if (typeof rootArray === 'string') {
              try {
                rootArray = JSON.parse(rootArray); 
              } catch (err) {
                console.error('Error parsing rootArray:', err);
                return res.status(400).json({ success: false, message: 'Invalid routes format.' });
              }
            }
    
        
            if (!Array.isArray(rootArray)) {
              console.error('rootArray is not an array after parsing.');
              return res.status(400).json({ success: false, message: 'Routes data is not an array.' });
            }
    
            console.log('Parsed rootArray:', rootArray);
    
          
            const rootData = [];
            for (const element of rootArray) {
              console.log('Element:', element);
    
              try {
                const data = await RootList.findAll({
                  attributes: ['id', 'name'], 
                  where: {
                    id: element, 
                  },
                });
                console.log('Data:', data);
                rootData.push(...data);
              } catch (err) {
                console.error('Error fetching data:', err);
              }
            }
    
         
            return res.status(200).json({ success: true, data: rootData });
          } else {
            console.error('No routes found for this user or date.');
            return res.status(404).json({ success: false, message: 'No routes found.' });
          }
        } catch (err) {
          console.error('Error in GET_EMPLOYEE_ROOT:', err);
          return res.status(500).json({ success: false, message: 'Internal server error.' });
        }
      } else {
        return res.status(400).json({ success: false, message: 'Missing userID parameter.' });
      }
    }
    
  }




function getToday() {
  const today = new Date();
  const year = today.getFullYear();
  const month = String(today.getMonth() + 1).padStart(2, '0'); // Months are 0-based
  const day = String(today.getDate()).padStart(2, '0');
  return `${year}-${month}-${day}`;
}

console.log(getToday());