const { Model, where, Sequelize, Op } = require('sequelize');
const { models: { Cards, Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails, Rental_Payment_Dtl, Rental_Payid_Dtl, RentalPaid }, sequelize } = require('../config/DB_config');
const { response, Router } = require('express');
module.exports = {
    GET_PAY_DTL: async (req, res, next) => {

        const accNo = req.query.accNo;
        const invNo = req.query.invNo;
        if (accNo && invNo) {
            try {

                Rental_Payment_Dtl.findAll({
                    where: { AccNo: accNo, InvNo: invNo }
                }).then((result) => {
                    res.send(result)
                })
            } catch (error) {
                console.log(error);
                res.send(error)
            }
        } else {
            res.send({ msg: 'enter all data' });
        }
    },

    GET_PAID_DTL: async (req, res, next) => {

        const accNo = req.query.accNo;
        const invNo = req.query.invNo;
        if (accNo && invNo) {
            try {

                Rental_Payid_Dtl.findAll({
                    where: { AccNo: accNo, InvNo: invNo },
                    attributes: ['PaymentId', 'PaymentType', 'PayAmount', 'PayAmount', 'InvNo', 'AccNo', 'Month'],
                }).then((result) => {
                    res.send(result)
                })
            } catch (error) {
                console.log(error);
                res.send(error)
            }
        } else {
            res.send({ msg: 'enter all data' });
        }
    },

    GET_Rental_Payment: async (req, res, next) => {

        const accNo = req.query.accNo;
        const invNo = req.query.invNo;
        if (accNo && invNo) {
            try {

                Rental_Payid_Dtl.findAll({
                    where: { AccNo: accNo, InvNo: invNo },
                    attributes: ['PaymentId', 'PaymentType', 'PayAmount', 'PayAmount', 'InvNo', 'AccNo', 'Month'],
                }).then((result) => {
                    res.send(result)
                })
            } catch (error) {
                console.log(error);
                res.send(error)
            }
        } else {
            res.send({ msg: 'enter all data' });
        }
    },
    GET_Payment_CARD_DATA: async (req, res, next) => {
        try {
            Cards.findAll({
            }).then((result) => {
                res.send(result)
            })
        } catch (error) {
            console.log(error);
            res.send(error)
        }
    },
    GET_USER_PAYMENTS: async (req, res, next) => {

        const accNo = req.query.accNo;
        const invNo = req.query.invNo;
        if (req.query.accNo && req.query.invNo) {
            try {
                RentalPaid.findAll({
                    where: { AccNo: accNo, InvNo: invNo },
                }).then((result) => {
                    res.send(result)
                })
            } catch (error) {
                console.log(error);
                res.send(error)
            }
        } else {
            console.log('no data ')
            res.send({ msg: 'enter all data' })
        }
    },

    GET_OFFLINE_DATA: async (req, res, next) => {
        console.log('offline data');
        const today = getToday()
        console.log(today);

        if(req.query.route){

            const route=req.query.route;
            await Invoice_hed.findAll({
                attributes:['InvNo','AccNo','TotalAmount','CusCode','TotalDue','InstallAmount','InterestTerm'],
                where: {
                    TotalDue: {
                        [Op.gt]: 0.00, 
                    },

                },
                include: [{
                    attributes:['RootNo','DisplayName','MobileNo','Address01','Address02','Address03','MobileNo','Nic'],
                    model: Customer,
                    required: true,
                    where:{RootNo:route}
                  

        
                  }]
                
            }).then(async(data)=>{
                res.send(data)
            })
        }else{
            res.status(500).send('no data');
        }





    }


}

function getToday() {
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0'); // Months are 0-based
    const day = String(now.getDate()).padStart(2, '0'); // Day of the month

    return `${year}-${month}-${day}`; // Format: YYYY-MM-DD
}