const { Model, where, Sequelize, Op } = require('sequelize');
const { models: { Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails, RentalPaid, RentalPaidCollector,Rental_Payment_Dtl }, sequelize } = require('../config/DB_config');





module.exports = {

  GetAllCards: async (req, res) => {
    if (req.query.rootId) {
      let whereObj = { IsCancel: 0 }
      let cusWhere = { RootNo: req.query.rootId }
      let userWhere = {}
      const data = req.query.data;
      if (data === 'all') {
        whereObj = { IsCancel: 0 }
      } else if (data === 'due') {
        whereObj = { IsCancel: 0, TotalDue: { [Op.gt]: 0.0 }, }
      } else if (data === 'mobileNo') {
        cusWhere = { RootNo: req.query.rootId, MobileNo: req.query.cardNo }
      } else if (data === 'isComplete') {
        whereObj = { IsCancel: 0, IsComplete: { [Op.gt]: 0 }, }
      } else if (data === 'expired') {
        const today = new Date().toISOString().split('T')[0];
        whereObj = { IsCancel: 0, lastDate: { [Op.lt]: today }, }
      } else if (data === 'cardNo') {
        whereObj = { IsCancel: 0, AccNo: req.query.cardNo }
      } else if (data === 'cusName') {
        cusWhere = { RootNo: req.query.rootId, CusName: { [Op.like]: `%${req.query.cardNo}%` } }
      } else if (data === 'dueVal') {
        let due = parseInt(req.query.cardNo);
        console.log('due:' + due)
        whereObj = { IsCancel: 0, To1talDue: { [Op.gte]: due }, }
      } else if (data === 'fPay') {
        let fpayemntVal = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, firstPayment: fpayemntVal }
      } else if (data === 'lornWInst') {
        let total = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, TotalAmount: { [Op.gte]: total }, }
      } else if (data === 'paidVal') {
        let total = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, TotalPaid: { [Op.gte]: total }, }
      } else if (data === 'insVal') {
        let total = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, Interest: { [Op.gte]: total }, }
      } else if (data === 'invoiceNo') {
        whereObj = { IsCancel: 0, InvNo: req.query.cardNo }

      } else if (data === 'userId') {
        whereObj = { IsCancel: 0, InvUser: req.query.cardNo }

      } else if (data === 'instTurm') {
        whereObj = { IsCancel: 0, InterestTerm: parseInt(req.query.cardNo) }
      } else if (data === 'date') {

        whereObj = {
          IsCancel: 0, [Op.and]: [
            sequelize.where(sequelize.fn('DATE', sequelize.col('lastDate')), req.query.cardNo)
          ]
        }
      } else if (data === 'cusCode') {
        cusWhere = { RootNo: req.query.rootId, CusCode: req.query.cardNo }
      }



      try {
        const data = await Invoice_hed.findAll({

          where: whereObj,

          include: [{
            model: InvType,
            required: true,

          }, {
            where: userWhere,
            attributes: ['username', 'id', 'role'],
            model: Users,
            required: true,
          }, {
            where: cusWhere,
            attributes: ['RootNo', 'CusCode', 'DisplayName', 'CusName', 'Nic', 'MobileNo'],
            model: Customer,
            required: true,
          },
          ],
        });


        res.json(data)
      } catch (error) {
        console.log(error);
        res.send(error)
      }


    } else {
      res.status(500).json({
        msg: 'no root id'
      })
    }
  },

  GET_DAY_INVOICE: async (req, res, next) => {
    console.log('getDayIUmnv')
    try {
      const { refId, routeID, date } = req.query
      if (req.query.refId && req.query.routeID && req.query.date) {

        await RentalPaidCollector.findAll({
          attributes: ['payment_Id'],
          where: {
            date: date,
            route_id: routeID,
            ref_id: refId
          },
          include: [{
            model: RentalPaid,
            attributes: ['CashPayment', 'AccNo', 'CusCode', 'PayDate'],
            where: { IsCancel: 0 },
            required: true,
            include: [{
              attributes: [ 'DisplayName', 'Nic', 'MobileNo'],
              model: Customer,
            }]

          }]
        }).then((data) => {
          data.forEach(element => {
            console.log('data', element.payment_Id);

          });
          res.send(data)
        })
      } else {
        console.log('empty feilds');
        res.status(400);
      }
    } catch (error) {
      console.log(error);
      res.status(500);
    }

  },

  GET_TODAY_INVOICE: async (req, res, next) => {
   const today = getToday();
    
    console.log('today is', today);
    if (req.query.rootId) {
      const root=req.query.rootId;
    try {
      console.log(today);
      const getTodayPaymentData = await Rental_Payment_Dtl.findAll({
        
        where: {
          PaymentDate:today,
          IsPaid: 0
        },
        include: [
          {
           
            model: Invoice_hed,
            include: [{
              model: InvType,
              required: true,

            }, {
              attributes: ['username', 'id', 'role'],
              model: Users,
              required: true,
            }, {
              attributes: ['RootNo', 'CusCode', 'DisplayName', 'CusName', 'Nic', 'MobileNo'],
              model: Customer,
              required: true,
              where:{RootNo: root}
            }]
          }

        ]

      });
      const transformedData = getTodayPaymentData.map(item => item.invoice_hed).filter(Boolean);

      // Log the transformed data
      console.log(transformedData);
  
      // Send the transformed data as the response
      if(transformedData){
        res.send(transformedData);
      }else{
        res.status(204);
      }
      
    
  
    
    } catch (error) {
      console.log(error)
    }
  }
  },


  GET_TODAY_INVOICE_EXPIRE: async (req, res, next) => {
   const today = getToday();
  
    console.log('today is', today);
    if (req.query.rootId) {
      const root=req.query.rootId;
    try {
      console.log(today);
      const getTodayPaymentData = await Rental_Payment_Dtl.findAll({
        attributes:[],
        where: {
          PaymentDate: { [Op.lt]: today},
          IsPaid: 0
        },
        include: [
          {
           
            model: Invoice_hed,
            include: [{
              model: InvType,
              required: true,

            }, {
              attributes: ['username', 'id', 'role'],
              model: Users,
              required: true,
            }, {
              attributes: ['RootNo', 'CusCode', 'DisplayName', 'CusName', 'Nic', 'MobileNo'],
              model: Customer,
              required: true,
              where:{RootNo: root}
            }]
          }

        ]

      });
      const transformedData = getTodayPaymentData.map(item => item.invoice_hed).filter(Boolean);

      // Log the transformed data
      console.log(transformedData);
  
      // Send the transformed data as the response
      if(transformedData){
        res.send(transformedData);
      }else{
        res.status(204);
      }
      
    
  
    
    } catch (error) {
      console.log(error)
    }
  }
  }
}


function getToday() {
  const today = new Date();
  const year = today.getFullYear();
  const month = String(today.getMonth() + 1).padStart(2, '0'); // Months are 0-based
  const day = String(today.getDate()).padStart(2, '0');
  return `${year}-${month}-${day}`;
}