const { Sequelize, DataTypes } = require('sequelize');

const sequelize = new Sequelize('nsoftsoft_sp_electrical', 'root', '', {
  host: 'localhost',
  dialect: 'mysql' ,
  
});

const db={}
db.models = {};
db.sequelize=sequelize;
db.models.Invoicehed=require('../modules/invoicehed')(sequelize,Sequelize,DataTypes);
db.models.RootList=require('../modules/root_list')(sequelize,Sequelize,DataTypes);
db.models.JobCardDtl=require('../modules/jobcarddtl')(sequelize,Sequelize,DataTypes);
db.models.InvType=require('../modules/inv_type')(sequelize,Sequelize,DataTypes);
db.models.Customer=require('../modules/customer')(sequelize,Sequelize,DataTypes);
db.models.Users=require('../modules/users')(sequelize,Sequelize,DataTypes);
db.models.Invoice_hed=require('../modules/invoice_hed')(sequelize,Sequelize,DataTypes);
db.models.Accdetails=require('../modules/account_details')(sequelize,Sequelize,DataTypes);
db.models.Item_interest=require('../modules/item_interest')(sequelize,Sequelize,DataTypes);
db.models.Rental_Payment_Dtl=require('../modules/rental_payment_dtl')(sequelize,Sequelize,DataTypes);
db.models.Rental_Payid_Dtl=require('../modules/rental_paid_dtl')(sequelize,Sequelize,DataTypes);
db.models.RentalPaid=require('../modules/rental_paid')(sequelize,Sequelize,DataTypes);
db.models.Cards=require('../modules/cards')(sequelize,Sequelize,DataTypes);
db.models.CustomerOutstanding=require('../modules/customeroutstanding')(sequelize,Sequelize,DataTypes);
db.models.RentalPaidCollector=require('../modules/rental_paid_collector')(sequelize,Sequelize,DataTypes);
db.models.DailyEmployeeRoutes=require('../modules/dayEmployeeRoutes')(sequelize,Sequelize,DataTypes);
db.models.Salespersons=require('../modules/salesPerson')(sequelize,Sequelize,DataTypes);
db.models.CodeGenerate=require('../modules/codegenerate')(sequelize,Sequelize,DataTypes);






db.models.Invoice_hed.hasMany(db.models.Rental_Payment_Dtl, {
  foreignKey: 'InvNo',   
  sourceKey: 'InvNo',   

});
db.models.Rental_Payment_Dtl.belongsTo(db.models.Invoice_hed, {
  foreignKey: 'InvNo',   
  targetKey: 'InvNo',   

});

db.models.DailyEmployeeRoutes.belongsTo(db.models.Salespersons, {
  foreignKey: 'salesperson',   
  targetKey: 'RepID',   

});

db.models.Salespersons.hasMany(db.models.DailyEmployeeRoutes, {
  foreignKey: 'salesperson',   
  targetKey: 'RepID',    

});




db.models.Invoicehed.belongsTo(db.models.RootList, {
  foreignKey: 'InvRootNo',   
  targetKey: 'id',   

});

db.models.RootList.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvRootNo',   
  sourceKey: 'id',   

});

db.models.Invoicehed.belongsTo(db.models.InvType, {
  foreignKey: 'InvType',   
  targetKey: 'invtype_id',   

});


db.models.InvType.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvType',   
  sourceKey: 'invtype_id',   

});



db.models.Invoicehed.belongsTo(db.models.Customer, {
  foreignKey: 'InvCustomer',   
  targetKey: 'CusCode',   

});

db.models.Customer.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvCustomer',   
  sourceKey: 'CusCode',   

});




db.models.Invoicehed.belongsTo(db.models.Users, {
  foreignKey: 'InvUser',   
  targetKey: 'id',   

});

db.models.Users.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvUser',   
  sourceKey: 'id',   

});





db.models.Invoice_hed.belongsTo(db.models.Users, {
  foreignKey: 'InvUser',   
  targetKey: 'id',   

});

db.models.Users.hasMany(db.models.Invoice_hed, {
  foreignKey: 'InvUser',   
  sourceKey: 'id',   

});

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
db.models.Invoicehed.belongsTo(db.models.RootList, {
  foreignKey: 'InvRootNo',   
  targetKey: 'id',   

});

db.models.RootList.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvRootNo',   
  sourceKey: 'id',   

});
*/

db.models.Invoice_hed.belongsTo(db.models.InvType, {
  foreignKey: 'InvType',   
  targetKey: 'invtype_id',   

});

db.models.InvType.hasMany(db.models.Invoice_hed, {
  foreignKey: 'InvType',   
  sourceKey: 'invtype_id',   

});

/*

db.models.Invoicehed.belongsTo(db.models.Customer, {
  foreignKey: 'InvCustomer',   
  targetKey: 'CusCode',   

});

db.models.Customer.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvCustomer',   
  sourceKey: 'CusCode',   

});
*/

//users

db.models.Invoice_hed.belongsTo(db.models.Users, {
  foreignKey: 'InvUser',   
  targetKey: 'id',   

});

db.models.Users.hasMany(db.models.Invoice_hed, {
  foreignKey: 'InvUser',   
  sourceKey: 'id',   

});


//account details



db.models.Invoice_hed.belongsTo(db.models.Accdetails, {
  foreignKey: 'AccNo',   
  targetKey: 'AccNo',   

});

db.models.Accdetails.hasMany(db.models.Invoice_hed, {
  foreignKey: 'AccNo',   
  sourceKey: 'AccNo',   

});

//customer


db.models.Invoice_hed.belongsTo(db.models.Customer, {
  foreignKey: 'CusCode',   
  targetKey: 'CusCode',   

});

db.models.Customer.hasMany(db.models.Invoice_hed, {
  foreignKey: 'CusCode',   
  sourceKey: 'CusCode',   

});



db.models.Invoicehed.belongsTo(db.models.Item_interest, {
  foreignKey: 'InterestTerm',   
  targetKey: 'IntTerm',   

});

db.models.Item_interest.hasMany(db.models.Invoicehed, {
  foreignKey: 'InterestTerm',   
  sourceKey: 'IntTerm',   

});

db.models.RentalPaidCollector.belongsTo(db.models.RentalPaid, {
  foreignKey: 'payment_Id',   
  targetKey: 'PaymentId',   

});

db.models.RentalPaid.hasMany(db.models.RentalPaidCollector, {
  foreignKey: 'payment_Id',   
  targetKey: 'PaymentId',  

});

db.models.RentalPaid.belongsTo(db.models.Customer, {
  foreignKey: 'CusCode',   
  targetKey: 'CusCode',   

});

db.models.Customer.hasMany(db.models.RentalPaid, {
  foreignKey: 'CusCode',   
  sourceKey: 'CusCode',   

});





module.exports=db;